<?php

namespace MbeGroup\Author\Filament;

use Filament\Contracts\Plugin;
use Filament\Panel;
use MbeGroup\Author\Filament\Resources\AuthorResource;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;

class AuthorPlugin implements Plugin
{
    public function getId(): string { return 'author'; }

    public function register(Panel $panel): void
    {
        $panel->resources([
            AuthorResource::class,
        ]);
    }

    public function boot(Panel $panel): void
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                NavigationGroup::make()
                     ->label(__('author::filament.navigation.group.label'))
                     ->icon('heroicon-s-briefcase'),
            ]);
        });
    }
}
