<?php
namespace MbeGroup\Author\Models;

use MongoDB\Laravel\Eloquent\Model;
use App\ValueObject\Status;
use App\Models\Dictionary;

class Author extends Model
{
    protected $connection = 'mongodb';
    protected $collection = 'authors';
    protected $fillable   = [
        'name',
        'position',
        'company_name',
        'type_id',
        'email',
        'image',
        'biography',
        'status',
    ];

    protected $casts = [
        'status'    => Status::class,
    ];

    public function type()
    {
        return $this->belongsTo(Dictionary::class, 'type_id');
    }
}
