# Testy jednostkowe modułu Author

## Opis

Testy jednostkowe dla modułu Author sprawdzają podstawową funkcjonalność:
- Model `Author` - struktura, fillable fields, casts, relacje
- `AuthorServiceProvider` - provider modułu Laravel
- `AuthorResource` - resource Filament
- `AuthorPlugin` - plugin Filament

## Struktura testów

```
tests/Unit/
├── AuthorTest.php              # Testy modelu Author
├── AuthorServiceProviderTest.php  # Testy service providera
├── AuthorResourceTest.php       # Testy Filament resource
└── AuthorPluginTest.php         # Testy Filament plugin
```

## Uruchomienie testów

### PHPUnit (bez Laravel)
Testy napisane są jako czyste unit testy PHPUnit, które sprawdzają strukturę klas przez refleksję:

```bash
# Z katalogu modułu author
./vendor/bin/phpunit tests/Unit/

# Konkretny test
./vendor/bin/phpunit tests/Unit/AuthorTest.php
```

### Laravel Artisan (jeśli moduł jest zintegrowany)
```bash
# Z katalogu głównego aplikacji Laravel
php artisan test --filter=AuthorTest
```

## Co sprawdzają testy

### AuthorTest
- ✅ Tworzenie instancji modelu
- ✅ Sprawdzenie fillable fields
- ✅ Sprawdzenie connection MongoDB
- ✅ Sprawdzenie nazwy kolekcji
- ✅ Sprawdzenie castów
- ✅ Sprawdzenie relacji z Dictionary (type)
- ✅ Sprawdzenie namespace i nazwy klasy
- ✅ Sprawdzenie dziedziczenia po MongoDB Model

### AuthorServiceProviderTest
- ✅ Sprawdzenie dziedziczenia po ServiceProvider
- ✅ Sprawdzenie wymaganych metod (boot, register)
- ✅ Sprawdzenie namespace

### AuthorResourceTest
- ✅ Sprawdzenie dziedziczenia po Filament Resource
- ✅ Sprawdzenie ustawienia modelu
- ✅ Sprawdzenie wymaganych metod (form, table, getPages)
- ✅ Sprawdzenie prywatnej metody configureStatusField

### AuthorPluginTest
- ✅ Sprawdzenie implementacji Plugin interface
- ✅ Sprawdzenie wymaganych metod (getId, register, boot)
- ✅ Sprawdzenie poprawności ID pluginu
- ✅ Sprawdzenie parametrów metod

## Przykładowe uruchomienie

```bash
cd /home/kamil/Projekty/Modules/author
composer require --dev phpunit/phpunit
./vendor/bin/phpunit tests/Unit/AuthorTest.php -v
```

## Wyniki testów

Wszystkie testy są zaprojektowane jako unit testy, które:
- Nie wymagają bazy danych
- Nie wymagają konfiguracji Laravel
- Sprawdzają tylko strukturę klas i ich właściwości
- Korzystają z PHP Reflection API

## Uwagi

- Testy używają PHPUnit\Framework\TestCase (czysty PHPUnit)
- Nie ma zależności od Laravel TestCase
- Sprawdzają tylko strukturę kodu, nie jego działanie
- Są szybkie i niezależne od środowiska