<?php

namespace MbeGroup\Author\Filament\Resources\AuthorResource\Pages;

use MbeGroup\Author\Filament\Resources\AuthorResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateAuthor extends CreateRecord
{
    protected static string $resource = AuthorResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('author::filament.resources.author.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
