<?php

namespace MbeGroup\Author\Contracts;

use MbeGroup\Author\Models\Author;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface AuthorServiceInterface
{
    public function listByType(array $filters = [], int $perPage = 15, int $page = 1): LengthAwarePaginator;

    public function listAll(array $filters = [], int $perPage = 15, int $page = 1): LengthAwarePaginator;

    public function get(string $slug): Author;

    public function create(array $data): Author;

    public function update(string $id, array $data): Author;

    public function delete(string $id): void;
}
