<?php

namespace MbeGroup\Author\Controllers\Api\V1;

use App\Http\Controllers\Api\V1\CrudApiController;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use MbeGroup\Author\Resources\AuthorResource;
use MbeGroup\Author\Contracts\AuthorServiceInterface;

final class AuthorController extends CrudApiController
{
    protected string $resourceName = 'author';

    public function __construct(
        protected AuthorServiceInterface $service,
    ) {
    }

    public function indexByType(Request $request, string $type): JsonResponse
    {
        return $this->notImplemented('indexByType');
    }

    public function index(Request $request): JsonResponse
    {
        return $this->notImplemented('index');
    }

    public function show(string $type): JsonResponse
    {
        $slug    = request()->route('slug');
        $author = $this->service->get($slug);

        return $this->success(new AuthorResource($author));
    }

    public function store(Request $request): JsonResponse
    {
        return $this->notImplemented('store');
    }

    public function update(Request $request, string $id): JsonResponse
    {
        return $this->notImplemented('update');
    }

    public function destroy(string $id): JsonResponse
    {
        return $this->notImplemented('destroy');
    }
}
