<?php
namespace MbeGroup\Author\Providers;

use Illuminate\Support\ServiceProvider;
use MbeGroup\Author\Contracts\AuthorServiceInterface;
use MbeGroup\Author\Services\AuthorService;

final class AuthorServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->bind(
            AuthorServiceInterface::class,
            AuthorService::class
        );
    }

    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');
        $this->loadTranslationsFrom(__DIR__ . '/../../lang', 'author');
    }
}
