<?php

namespace MbeGroup\Author\Repository;

use MbeGroup\Author\Models\Author;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Collection;
use App\ValueObject\Status;

class AuthorRepository
{
    public function paginate(array $filters = [], int $perPage = 15, int $page = 1): LengthAwarePaginator
    {
        $query = Author::query()
            ->when($filters['q'] ?? null, function ($query, $search) {
                $query->where(function ($q) use ($search) {
                    $q->where('name', 'like', "%{$search}%");
                });
            })
            ->where('status', Status::ACTIVE)
            ->orderByDesc('created_at');

        return $query->paginate($perPage, ['*'], 'page', $page);
    }

    public function all(): Collection
    {
        return Author::query()
            ->orderByDesc('created_at')
            ->where('status', Status::ACTIVE)
            ->get();
    }

    public function findById(string $id): Author
    {
        return Author::where('id', $id)->where('status', Status::ACTIVE)->firstOrFail();
    }

    public function findBySlug(string $slug): Author
    {
        return Author::where('slug', $slug)->where('status', Status::ACTIVE)->firstOrFail();
    }

    public function create(array $data): Author
    {
        return Author::create($data);
    }

    public function update(Author $author, array $data): Author
    {
        $author->update($data);

        return $author;
    }

    public function delete(Author $author): void
    {
        $author->delete();
    }
}
