<?php

namespace MbeGroup\Author\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AuthorResource extends JsonResource
{
      /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'           => $this->id ?? null,
            'slug'         => $this->slug ?? null,
            'name'         => $this->name ?? null,
            'position'     => $this->position ?? null,
            'company_name' => $this->company_name ?? null,
            'image'        => $this->getImageUrlAttribute() ?? null,
            'biography'    => $this->biography ?? null,
        ];
    }
}
