<?php

namespace MbeGroup\Author\Services;

use MbeGroup\Author\Repository\AuthorRepository;
use MbeGroup\Author\Models\Author;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use MbeGroup\Author\Contracts\AuthorServiceInterface;

class AuthorService implements AuthorServiceInterface
{
    public function __construct(
        protected AuthorRepository $authors,
    ) {}

    public function listByType(array $filters = [], int $perPage = 15, int $page = 1): LengthAwarePaginator
    {
        return $this->authors->paginate($filters, $perPage, $page);
    }

    public function listAll(array $filters = [], int $perPage = 15, int $page = 1): LengthAwarePaginator
    {
        return $this->authors->paginate($filters, $perPage, $page);
    }

    public function get(string $slug): Author
    {
        return $this->authors->findBySlug($slug);
    }

    public function create(array $data): Author
    {
        return $this->authors->create($data);
    }

    public function update(string $id, array $data): Author
    {
        $author = $this->authors->findById($id);

        return $this->authors->update($author, $data);
    }

    public function delete(string $id): void
    {
        $author = $this->authors->findById($id);

        $this->authors->delete($author);
    }
}
