<?php

namespace MbeGroup\Content\Filament;

use Filament\Contracts\Plugin;
use Filament\Panel;
use MbeGroup\Content\Filament\Resources\ContentResource;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;

class ContentPlugin implements Plugin
{
    public function getId(): string { return 'content'; }

    public function register(Panel $panel): void
    {
        $panel->resources([
            ContentResource::class,
        ]);
    }

    public function boot(Panel $panel): void
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                NavigationGroup::make()
                     ->label(__('content::filament.navigation.group.label'))
                     ->icon('heroicon-s-pencil'),
            ]);
        });
    }
}
