<?php

namespace MbeGroup\Content\Filament\Resources;

use MbeGroup\Content\Models\Content;

use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables;
use Filament\Tables\Table;
use MbeGroup\Content\Filament\Resources\ContentResource\Pages\ListContents;
use MbeGroup\Content\Filament\Resources\ContentResource\Pages\CreateContent;
use MbeGroup\Content\Filament\Resources\ContentResource\Pages\EditContent;
use Filament\Actions;
use Filament\Forms;
use App\ValueObject\Status;

class ContentResource extends Resource
{
    protected static ?string $model = Content::class;

    public static function getNavigationGroup(): string
    {
        return __('content::filament.navigation.group.label');
    }

    public static function getNavigationLabel(): string
    {
        return __('content::filament.resources.content.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('content::filament.resources.content.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('content::filament.resources.content.plural_model_label');
    }

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label(__('content::filament.resources.content.form.fields.name'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\Select::make('status')
                        ->label(__('content::filament.resources.content.form.fields.status'))
                        ->options(Status::getLabels())
                        ->required()
                        ->default(Status::INACTIVE)
                        ->afterStateHydrated(function (Forms\Components\Select $component, $state): void {
                            if ($state instanceof Status) {
                                $component->state($state->value);
                            }
                        })
                        ->dehydrateStateUsing(function ($state): int {
                            return $state instanceof Status ? $state->value: (int) $state;
                        })
                        ->rule('integer')
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('ID')
                    ->sortable(),
                Tables\Columns\TextColumn::make('name')
                    ->label(__('content::filament.resources.content.table.columns.name'))
                    ->searchable(),
                Tables\Columns\IconColumn::make('status')
                    ->label(__('content::filament.resources.content.table.columns.status'))
                    ->state(fn ($record) => Status::int($record->status))
                    ->icon(fn ($state) => Status::icon($state))
                    ->color(fn ($state) => Status::color($state))
                    ->tooltip(fn ($state) => Status::label($state))
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                ->label(__('content::filament.resources.content.table.columns.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                ->label(__('content::filament.resources.content.table.columns.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                Actions\EditAction::make(),
                Actions\DeleteAction::make(),
            ])
            ->toolbarActions([
                Actions\BulkActionGroup::make([
                    Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->description('Version: ' . \Composer\InstalledVersions::getVersion('mbegroup/content'));
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListContents::route('/'),
            'create' => CreateContent::route('/create'),
            'edit' => EditContent::route('/{record}/edit'),
        ];
    }
}
