<?php
namespace MbeGroup\Content\Models;

use MongoDB\Laravel\Eloquent\Model;
use App\ValueObject\Status;
use App\Models\Dictionary;
use Illuminate\Database\Eloquent\Builder;
use MbeGroup\Employer\Models\Employer;
use App\Traits\HasSeoFields;
use MbeGroup\Author\Models\Author;

class Content extends Model
{
    use HasSeoFields;
    protected $connection = 'mongodb';
    protected $collection = 'contents';
    protected $fillable   = [
        'title',
        'subtitle',
        'slug',
        'short_title',
        'content_category_id',
        'industry_ids',
        'specialization_ids',
        'employer_id',
        'location',
        'is_sponsored',
        'is_sticky',
        'main_image',
        'main_image_caption',
        'status',
        'type',
        'lead',
        'content',
        'tags',
        'publication_date',
        'author_ids',
        'expert_ids',
        'employer_image',
        'project_type',
        'project_scope',
        'project_duration',
        'people_involved_count',
        'key_numbers',
        'quotes',
        'gallery',
        'team_description',
        'involved_people',
        'team_composition',
        'software',
        'hardware',
        'methodologies',
        'gallery',
    ];

    protected $casts = [
        'status'             => Status::class,
        'industry_ids'       => 'array',
        'specialization_ids' => 'array',
        'tags'               => 'array',
        'location'           => 'array',
        'expert_ids'         => 'array',
        'author_ids'         => 'array',
        'key_numbers'        => 'array',
        'quotes'             => 'array',
        'gallery'            => 'array',
        'involved_people'    => 'array',
        'team_composition'   => 'array',
        'methodologies'      => 'array',
        'hardware'           => 'array',
        'software'           => 'array',
        'gallery'            => 'array',
    ];

    public function contentCategory()
    {
        return $this->belongsTo(Dictionary::class, 'content_category_id');
    }

    public function employer()
    {
        return $this->belongsTo(Employer::class, 'employer_id');
    }

    public function industries()
    {
        return $this->belongsToMany(Dictionary::class, null, 'industry_ids', '_id');
    }

    public function specializations()
    {
        return $this->belongsToMany(Dictionary::class, null, 'specialization_ids', '_id');
    }

    public function scopeOfType(Builder $query, string $type): Builder
    {
        return $query->where('type', $type);
    }

    public function experts()
    {
        return $this->belongsToMany(Author::class, null, 'expert_ids', '_id');
    }

    public function authors()
    {
        return $this->belongsToMany(Author::class, null, 'author_ids', '_id');
    }
}
