<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources;

use MbeGroup\Content\Filament\Resources\BaseContentResource;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\JobPositionDescriptionResource\Pages;

class JobPositionDescriptionResource extends BaseContentResource
{
    protected static string $contentType = 'job_position_description';

    protected static ?string $slug = 'job-position-descriptions';

    protected static ?string $cluster = KnowledgeBase::class;

    public static function getNavigationGroup(): ?string
    {
        return null;
    }

    public static function getNavigationSort(): ?int
    {
        return 2;
    }

    public static function getNavigationLabel(): string
    {
        return __('content::filament.resources.job_position_descriptions.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('content::filament.resources.job_position_descriptions.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('content::filament.resources.job_position_descriptions.plural_model_label');
    }

    public static function getPages(): array
    {
        return [
            'index'  => Pages\ListJobPositionDescriptions::route('/'),
            'create' => Pages\CreateJobPositionDescription::route('/create'),
            'edit'   => Pages\EditJobPositionDescription::route('/{record}/edit'),
        ];
    }
}
