<?php

namespace MbeGroup\Content\Filament\Resources\ArticleResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use MbeGroup\Content\Filament\Resources\ArticleResource;

class EditArticle extends EditRecord
{
    protected static string $resource = ArticleResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function getFormActions(): array
    {
        return [
            $this->getSaveFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.general.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->save();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            $this->getCancelFormAction(),
        ];
    }
}
