<?php

namespace MbeGroup\Content\Tests\Unit\Filament\Resources;

use MbeGroup\Content\Filament\Resources\ArticleResource;
use MbeGroup\Content\Filament\Resources\BaseContentResource;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

class ArticleResourceTest extends TestCase
{
    /**
     * Test sprawdzający czy dziedziczy po BaseContentResource
     */
    public function test_extends_base_content_resource(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $this->assertTrue($reflection->isSubclassOf(BaseContentResource::class));
    }

    /**
     * Test sprawdzający czy ma ustawiony contentType na 'article'
     */
    public function test_has_article_content_type(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $contentTypeProperty = $reflection->getProperty('contentType');
        $contentTypeProperty->setAccessible(true);
        $contentType = $contentTypeProperty->getValue();

        $this->assertEquals('article', $contentType);
    }

    /**
     * Test sprawdzający czy ma ustawiony slug
     */
    public function test_has_slug_property(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $slugProperty = $reflection->getProperty('slug');
        $slugProperty->setAccessible(true);
        $slug = $slugProperty->getValue();

        $this->assertEquals('content/articles', $slug);
    }

    /**
     * Test sprawdzający czy ma metodę getNavigationSort
     */
    public function test_has_get_navigation_sort_method(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $this->assertTrue($reflection->hasMethod('getNavigationSort'));

        $method = $reflection->getMethod('getNavigationSort');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy metoda getNavigationSort zwraca int
     */
    public function test_get_navigation_sort_returns_int(): void
    {
        $result = ArticleResource::getNavigationSort();

        $this->assertIsInt($result);
        $this->assertEquals(1, $result);
    }

    /**
     * Test sprawdzający czy ma metodę getNavigationLabel
     */
    public function test_has_get_navigation_label_method(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $this->assertTrue($reflection->hasMethod('getNavigationLabel'));

        $method = $reflection->getMethod('getNavigationLabel');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy ma metodę getModelLabel
     */
    public function test_has_get_model_label_method(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $this->assertTrue($reflection->hasMethod('getModelLabel'));

        $method = $reflection->getMethod('getModelLabel');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy ma metodę getPluralModelLabel
     */
    public function test_has_get_plural_model_label_method(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $this->assertTrue($reflection->hasMethod('getPluralModelLabel'));

        $method = $reflection->getMethod('getPluralModelLabel');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy ma metodę getPages
     */
    public function test_has_get_pages_method(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $this->assertTrue($reflection->hasMethod('getPages'));

        $method = $reflection->getMethod('getPages');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy getPages zwraca tablicę
     */
    public function test_get_pages_returns_array(): void
    {
        $pages = ArticleResource::getPages();

        $this->assertIsArray($pages);
        $this->assertArrayHasKey('index', $pages);
        $this->assertArrayHasKey('create', $pages);
        $this->assertArrayHasKey('edit', $pages);
    }

    /**
     * Test sprawdzający poprawny namespace
     */
    public function test_correct_namespace(): void
    {
        $reflection = new ReflectionClass(ArticleResource::class);

        $this->assertEquals('MbeGroup\Content\Filament\Resources', $reflection->getNamespaceName());
    }
}
