<?php

namespace MbeGroup\Content\Tests\Unit\Filament\Resources;

use MbeGroup\Content\Filament\Resources\BaseContentResource;
use MbeGroup\Content\Models\Content;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

class BaseContentResourceTest extends TestCase
{
    /**
     * Test sprawdzający czy klasa dziedziczy po Filament Resource
     */
    public function test_extends_filament_resource(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertTrue($reflection->isSubclassOf('Filament\Resources\Resource'));
    }

    /**
     * Test sprawdzający czy ma ustawiony model Content
     */
    public function test_has_content_model(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $modelProperty = $reflection->getProperty('model');
        $modelProperty->setAccessible(true);
        $model = $modelProperty->getValue();

        $this->assertEquals(Content::class, $model);
    }

    /**
     * Test sprawdzający czy ma zdefiniowaną właściwość contentType
     */
    public function test_has_content_type_property(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertTrue($reflection->hasProperty('contentType'));

        $contentTypeProperty = $reflection->getProperty('contentType');
        $this->assertTrue($contentTypeProperty->isStatic());
        $this->assertTrue($contentTypeProperty->isProtected());
    }

    /**
     * Test sprawdzający czy klasa jest abstrakcyjna
     */
    public function test_is_abstract_class(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertTrue($reflection->isAbstract());
    }

    /**
     * Test sprawdzający czy ma metodę getNavigationGroup
     */
    public function test_has_get_navigation_group_method(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertTrue($reflection->hasMethod('getNavigationGroup'));

        $method = $reflection->getMethod('getNavigationGroup');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy ma metodę form
     */
    public function test_has_form_method(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertTrue($reflection->hasMethod('form'));

        $method = $reflection->getMethod('form');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
        $this->assertCount(1, $method->getParameters());
    }

    /**
     * Test sprawdzający czy ma metodę table
     */
    public function test_has_table_method(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertTrue($reflection->hasMethod('table'));

        $method = $reflection->getMethod('table');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
        $this->assertCount(1, $method->getParameters());
    }

    /**
     * Test sprawdzający czy ma metodę getEloquentQuery
     */
    public function test_has_get_eloquent_query_method(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertTrue($reflection->hasMethod('getEloquentQuery'));

        $method = $reflection->getMethod('getEloquentQuery');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający poprawny namespace
     */
    public function test_correct_namespace(): void
    {
        $reflection = new ReflectionClass(BaseContentResource::class);

        $this->assertEquals('MbeGroup\Content\Filament\Resources', $reflection->getNamespaceName());
    }
}
