<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\DictionaryEntryResource\Pages;

use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\DictionaryEntryResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateDictionaryEntry extends CreateRecord
{
    protected static string $resource = DictionaryEntryResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.general.createAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
