<?php

namespace MbeGroup\Content\Filament\Clusters;

use Filament\Clusters\Cluster;
use Filament\Pages\Enums\SubNavigationPosition;

class KnowledgeBase extends Cluster
{
    protected static ?int $navigationSort = 3;

    protected static ?string $slug = 'content/knowledge-base';

    protected static ?SubNavigationPosition $subNavigationPosition = SubNavigationPosition::Top;

    public static function getNavigationGroup(): ?string
    {
        return __('content::filament.navigation.group.label');
    }

    public static function getNavigationLabel(): string
    {
        return __('content::filament.clusters.knowledge_base.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('content::filament.resources.knowledge_base.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('content::filament.resources.knowledge_base.plural_model_label');
    }

    public static function getClusterBreadcrumb(): ?string
    {
        return __('content::filament.clusters.knowledge_base.breadcrumb');
    }

}
