<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources;

use MbeGroup\Content\Filament\Resources\BaseContentResource;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\QualificationResource\Pages;

class QualificationResource extends BaseContentResource
{
    protected static string $contentType = 'qualification';

    protected static ?string $slug = 'qualifications';

    protected static ?string $cluster = KnowledgeBase::class;

    public static function getNavigationGroup(): ?string
    {
        return null;
    }

    public static function getNavigationSort(): ?int
    {
        return 3;
    }

    public static function getNavigationLabel(): string
    {
        return __('content::filament.resources.qualifications.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('content::filament.resources.qualifications.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('content::filament.resources.qualifications.plural_model_label');
    }

    public static function getPages(): array
    {
        return [
            'index'  => Pages\ListQualifications::route('/'),
            'create' => Pages\CreateQualification::route('/create'),
            'edit'   => Pages\EditQualification::route('/{record}/edit'),
        ];
    }
}
