<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\JobPositionDescriptionResource\Pages;

use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\JobPositionDescriptionResource;
use Filament\Resources\Pages\EditRecord;
use Filament\Actions;

class EditJobPositionDescription extends EditRecord
{
    protected static string $resource = JobPositionDescriptionResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getSaveFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.general.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->save();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            $this->getCancelFormAction(),
        ];
    }
}
