<?php

namespace MbeGroup\Content\Services;

use MbeGroup\Content\Repository\ContentRepository;
use MbeGroup\Content\Models\Content;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use MbeGroup\Content\Contracts\ContentServiceInterface;

class ContentService implements ContentServiceInterface
{
    public function __construct(
        protected ContentRepository $contents,
    ) {}

    public function listByType(array $filters = [], int $perPage = 15, int $page = 1, string $type): LengthAwarePaginator
    {
        return $this->contents->paginate($filters, $perPage, $page, $type);
    }

    public function listAll(array $filters = [], int $perPage = 15, int $page = 1): LengthAwarePaginator
    {
        return $this->contents->paginate($filters, $perPage, $page, '');
    }

    public function get(string $slug): Content
    {
        return $this->contents->findBySlug($slug);
    }

    public function getByType(string $slug, string $type): Content
    {
        return $this->contents->findBySlugAndType($slug, $type);
    }

    public function create(array $data): Content
    {
        return $this->contents->create($data);
    }

    public function update(string $id, array $data): Content
    {
        $content = $this->contents->findById($id);

        return $this->contents->update($content, $data);
    }

    public function delete(string $id): void
    {
        $content = $this->contents->findById($id);

        $this->contents->delete($content);
    }
}
