<?php

use Illuminate\Support\Facades\Route;
use MbeGroup\Content\Controllers\Api\V1;

Route::prefix('api')->group(function () {
    Route::prefix('v1')->group(function () {
        Route::middleware('auth:sanctum')->group(function () {
            Route::prefix('contents')->group(function () {
                Route::get('/', [V1\ContentController::class, 'index']);
                Route::prefix('/{type}')->group(function () {
                    Route::get('/', [V1\ContentController::class, 'indexByType']);
                    Route::get('/{slug}', [V1\ContentController::class, 'show']);
                });
            });
        });
    });
});
