<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources;

use MbeGroup\Content\Filament\Resources\BaseContentResource;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\TechnologyToolResource\Pages;

class TechnologyToolResource extends BaseContentResource
{
    protected static string $contentType = 'technology_tool';

    protected static ?string $slug = 'technology-tools';

    protected static ?string $cluster = KnowledgeBase::class;

    public static function getNavigationGroup(): ?string
    {
        return null;
    }

    public static function getNavigationSort(): ?int
    {
        return 4;
    }

    public static function getNavigationLabel(): string
    {
        return __('content::filament.resources.technology_tools.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('content::filament.resources.technology_tools.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('content::filament.resources.technology_tools.plural_model_label');
    }

    public static function getPages(): array
    {
        return [
            'index'  => Pages\ListTechnologyTools::route('/'),
            'create' => Pages\CreateTechnologyTool::route('/create'),
            'edit'   => Pages\EditTechnologyTool::route('/{record}/edit'),
        ];
    }
}
