<?php

namespace MbeGroup\Content\Filament;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;
use MbeGroup\Content\Filament\Resources\ArticleResource;
use MbeGroup\Content\Filament\Resources\ProjectResource;

class ContentPlugin implements Plugin
{
    public function getId(): string { return 'content'; }

    public function register(Panel $panel): void
    {
        $panel->resources([
            ArticleResource::class,
            ProjectResource::class,
        ])
        ->discoverClusters(in: __DIR__ . '/Clusters', for: 'MbeGroup\\Content\\Filament\\Clusters')
        ;
    }

    public function boot(Panel $panel): void
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                NavigationGroup::make()
                     ->label(__('content::filament.navigation.group.label'))
                     ->icon('heroicon-s-pencil-square')
            ]);
        });
    }
}
