<?php

namespace MbeGroup\Content\Filament\Resources\ProjectResource\Pages;

use MbeGroup\Content\Filament\Resources\ProjectResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateProject extends CreateRecord
{
    protected static string $resource = ProjectResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.resources.users.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
