<?php

namespace MbeGroup\Content\Tests\Unit\Providers;

use MbeGroup\Content\Providers\ContentServiceProvider;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

class ContentServiceProviderTest extends TestCase
{
    /**
     * Test sprawdzający czy dziedziczy po Illuminate ServiceProvider
     */
    public function test_extends_service_provider(): void
    {
        $reflection = new ReflectionClass(ContentServiceProvider::class);

        $this->assertTrue($reflection->isSubclassOf('Illuminate\Support\ServiceProvider'));
    }

    /**
     * Test sprawdzający czy ma metodę boot
     */
    public function test_has_boot_method(): void
    {
        $reflection = new ReflectionClass(ContentServiceProvider::class);

        $this->assertTrue($reflection->hasMethod('boot'));

        $method = $reflection->getMethod('boot');
        $this->assertTrue($method->isPublic());
        $this->assertCount(0, $method->getParameters());
    }

    /**
     * Test sprawdzający czy metoda boot ma poprawny return type
     */
    public function test_boot_method_return_type(): void
    {
        $reflection = new ReflectionClass(ContentServiceProvider::class);
        $method = $reflection->getMethod('boot');

        $returnType = $method->getReturnType();
        $this->assertNotNull($returnType);
        $this->assertEquals('void', $returnType->getName());
    }

    /**
     * Test sprawdzający czy klasa jest final
     */
    public function test_class_is_final(): void
    {
        $reflection = new ReflectionClass(ContentServiceProvider::class);

        $this->assertTrue($reflection->isFinal());
    }

    /**
     * Test sprawdzający poprawny namespace
     */
    public function test_correct_namespace(): void
    {
        $reflection = new ReflectionClass(ContentServiceProvider::class);

        $this->assertEquals('MbeGroup\Content\Providers', $reflection->getNamespaceName());
    }

    /**
     * Test sprawdzający czy można stworzyć instancję
     */
    public function test_can_instantiate(): void
    {
        // Mock aplikacji Laravel potrzebny dla ServiceProvider
        $app = $this->createMock('Illuminate\Contracts\Foundation\Application');

        $provider = new ContentServiceProvider($app);

        $this->assertInstanceOf(ContentServiceProvider::class, $provider);
    }

    /**
     * Test sprawdzający czy nie ma metody register (opcjonalna w service providerach)
     */
    public function test_register_method_existence(): void
    {
        $reflection = new ReflectionClass(ContentServiceProvider::class);

        // Sprawdzamy czy ma metodę register - jeśli nie ma, to też jest ok
        if ($reflection->hasMethod('register')) {
            $method = $reflection->getMethod('register');
            $this->assertTrue($method->isPublic());
        }

        // Test przejdzie niezależnie od tego czy metoda register istnieje
        $this->assertTrue(true);
    }
}
