<?php

use Illuminate\Support\Facades\Route;
use MbeGroup\Content\Controllers\Api\V1;

Route::prefix('api')->group(function () {
    Route::prefix('v1')->group(function () {
        Route::middleware('auth:sanctum')->group(function () {
            Route::prefix('contents')->group(function () {
                Route::get('/types', [V1\ContentController::class, 'types']);
                Route::get('/dictionary-filters/{type}', [V1\ContentController::class, 'dictionaryFilters']);
                Route::get('/', [V1\ContentController::class, 'index']);
                Route::get('/{slug}', [V1\ContentController::class, 'show']);
                Route::prefix('/type/{type}')->group(function () {
                    Route::get('/', [V1\ContentController::class, 'indexByType']);
                    Route::get('/{slug}', [V1\ContentController::class, 'showByType']);
                });
            });

             Route::prefix('sitemaps')->group(function () {
                 Route::prefix('contents')->group(function () {
                    Route::get('/', [V1\SitemapController::class, 'show']);
                    Route::delete('/cache', [V1\SitemapController::class, 'clearCache']);
                    Route::delete('/cache/all', [V1\SitemapController::class, 'clearAllCache']);
                });
            });
        });
    });
});
