<?php

namespace MbeGroup\Content\Contracts;

use MbeGroup\Content\Models\Content;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface ContentServiceInterface
{
    public function listByType(array $filters = [], int $perPage = 15, int $page = 1, string $type): LengthAwarePaginator;

    public function listAll(array $filters = [], int $perPage = 15, int $page = 1): LengthAwarePaginator;

    public function get(string $slug): Content;

    public function getByType(string $slug, string $type): Content;

    public function create(array $data): Content;

    public function update(string $id, array $data): Content;

    public function delete(string $id): void;

    public function listContentTypes(array $filters = []): array;

    public function determineSeoKey(?string $contentCategoryIds): string;

    public function getListForSitemap(string $contentCategoryId, int $perPage = 50, int $page = 1): LengthAwarePaginator;

    public function getDictionaryFiltersForContent(array $filters, int $perPage = 15): LengthAwarePaginator;
}
