<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\TechnologyToolResource\Pages;

use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\TechnologyToolResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateTechnologyTool extends CreateRecord
{
    protected static string $resource = TechnologyToolResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.general.createAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
