<?php
namespace MbeGroup\Content\Providers;

use Illuminate\Support\ServiceProvider;
use MbeGroup\Content\Contracts\ContentServiceInterface;
use MbeGroup\Content\Services\ContentService;

final class ContentServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(
            ContentServiceInterface::class,
            ContentService::class
        );
    }

    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');
        $this->loadTranslationsFrom(__DIR__ . '/../../lang', 'content');
    }
}
