<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\DictionaryEntryResource\Pages;

use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\DictionaryEntryResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditDictionaryEntry extends EditRecord
{
    protected static string $resource = DictionaryEntryResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function getFormActions(): array
    {
        return [
            $this->getSaveFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.general.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->save();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            $this->getCancelFormAction(),
        ];
    }
}
