<?php

namespace MbeGroup\Content\Filament\Resources;

use MbeGroup\Content\Filament\Resources\BaseContentResource;

class ArticleResource extends BaseContentResource
{
    protected static string $contentType = 'article';

    protected static ?string $slug = 'content/articles';

    protected static ?string $dictionarySlug = 'articles';

    public static function getNavigationSort(): ?int
    {
        return 1;
    }

    public static function getNavigationLabel(): string
    {
        return __('content::filament.resources.article.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('content::filament.resources.article.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('content::filament.resources.article.plural_model_label');
    }

    public static function getPages(): array
    {
        return [
            'index'  => \MbeGroup\Content\Filament\Resources\ArticleResource\Pages\ListArticles::route('/'),
            'create' => \MbeGroup\Content\Filament\Resources\ArticleResource\Pages\CreateArticle::route('/create'),
            'edit'   => \MbeGroup\Content\Filament\Resources\ArticleResource\Pages\EditArticle::route('/{record}/edit'),
        ];
    }
}
