<?php

namespace MbeGroup\Content\Tests\Unit\Models;

use MbeGroup\Content\Models\Content;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

class ContentRelationshipsTest extends TestCase
{
    /**
     * Test sprawdzający relację z kategorią treści
     */
    public function test_content_category_relationship(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $this->assertTrue($reflection->hasMethod('contentCategory'));

        $method = $reflection->getMethod('contentCategory');
        $this->assertTrue($method->isPublic());
        $this->assertCount(0, $method->getParameters());
    }

    /**
     * Test sprawdzający relację z pracodawcą
     */
    public function test_employer_relationship(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $this->assertTrue($reflection->hasMethod('employer'));

        $method = $reflection->getMethod('employer');
        $this->assertTrue($method->isPublic());
        $this->assertCount(0, $method->getParameters());
    }

    /**
     * Test sprawdzający relację z branżami
     */
    public function test_industries_relationship(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $this->assertTrue($reflection->hasMethod('getIndustries'));

        $method = $reflection->getMethod('getIndustries');
        $this->assertTrue($method->isPublic());
        $this->assertCount(0, $method->getParameters());
    }

    /**
     * Test sprawdzający relację ze specjalizacjami
     */
    public function test_specializations_relationship(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $this->assertTrue($reflection->hasMethod('getSpecializations'));

        $method = $reflection->getMethod('getSpecializations');
        $this->assertTrue($method->isPublic());
        $this->assertCount(0, $method->getParameters());
    }

    /**
     * Test sprawdzający relację z ekspertami
     */
    public function test_experts_relationship(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $this->assertTrue($reflection->hasMethod('experts'));

        $method = $reflection->getMethod('experts');
        $this->assertTrue($method->isPublic());
        $this->assertCount(0, $method->getParameters());
    }

    /**
     * Test sprawdzający relację z autorami
     */
    public function test_authors_relationship(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $this->assertTrue($reflection->hasMethod('getAuthorsListAttribute'));

        $method = $reflection->getMethod('getAuthorsListAttribute');
        $this->assertTrue($method->isPublic());
        $this->assertCount(0, $method->getParameters());
    }

    /**
     * Test sprawdzający czy wszystkie metody relacyjne istnieją
     */
    public function test_all_relationship_methods_exist(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $expectedRelationships = [
            'contentCategory',
            'employer',
            'getIndustries',
            'getSpecializations',
            'experts',
            'getAuthorsListAttribute'
        ];

        foreach ($expectedRelationships as $relationship) {
            $this->assertTrue(
                $reflection->hasMethod($relationship),
                "Metoda relacji '{$relationship}' nie została znaleziona"
            );

            $method = $reflection->getMethod($relationship);
            $this->assertTrue($method->isPublic(), "Metoda '{$relationship}' powinna być publiczna");
        }
    }

    /**
     * Test sprawdzający czy metody relacji belongsTo mają odpowiednie parametry
     */
    public function test_belongs_to_relationship_parameters(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $belongsToMethods = ['contentCategory', 'employer'];

        foreach ($belongsToMethods as $method) {
            $relationshipMethod = $reflection->getMethod($method);
            $this->assertCount(
                0,
                $relationshipMethod->getParameters(),
                "Metoda belongsTo '{$method}' nie powinna mieć parametrów"
            );
        }
    }

    /**
     * Test sprawdzający czy metody relacji belongsToMany mają odpowiednie parametry
     */
    public function test_belongs_to_many_relationship_parameters(): void
    {
        $content = new Content();
        $reflection = new ReflectionClass($content);

        $belongsToManyMethods = ['getIndustries', 'getSpecializations', 'experts', 'getAuthorsListAttribute'];

        foreach ($belongsToManyMethods as $method) {
            $relationshipMethod = $reflection->getMethod($method);
            $this->assertCount(
                0,
                $relationshipMethod->getParameters(),
                "Metoda belongsToMany '{$method}' nie powinna mieć parametrów"
            );
        }
    }
}
