<?php

namespace MbeGroup\Content\Controllers\Api\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Api\V1\AbstractSitemapController;
use MbeGroup\Content\Contracts\ContentServiceInterface;
use MbeGroup\Content\Resources\SitemapContentResource;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use App\Helpers\DictionaryHelper;

final class SitemapController extends AbstractSitemapController
{
    public function __construct(
        protected ContentServiceInterface $service,
    ) {
    }

      /**
     * Get sitemap data for contents
     */
    protected function getSitemapData(Request $request): ?LengthAwarePaginator
    {
        $contentCategoryId = $request->input('content_category_id');
        $contentCategory = DictionaryHelper::getSlugById($contentCategoryId);
        if (!$contentCategoryId || !$contentCategory) {
            return null;
        }

        $perPage = (int) $request->input('limit', 50);
        $page    = (int) $request->input('page', 1);

        return $this->service->getListForSitemap($contentCategoryId, $perPage, $page);
    }

    protected function getResourceClass(): string
    {
        return SitemapContentResource::class;
    }

        /**
     * Get cache key prefix
     */
    protected function getCacheKeyPrefix(): string
    {
        return 'contents';
    }
}
