<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\JobPositionDescriptionResource\Pages;

use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\JobPositionDescriptionResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateJobPositionDescription extends CreateRecord
{
    protected static string $resource = JobPositionDescriptionResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.general.createAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
