<?php

namespace MbeGroup\Content\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SitemapContentResource extends JsonResource
{
        /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'              => $this->id,
            'title'           => $this->title,
            'subtitle'        => $this->subtitle,
            'slug'            => $this->slug,
            'type'            => $this->type,
            'category'        => $this->getCategory() ? $this->getCategory()->first() : null,
            'created_at'       => $this->created_at,
            'updated_at'       => $this->updated_at,
        ];
    }
}
