<?php

namespace MbeGroup\Content\Tests\Unit\Filament\Clusters;

use MbeGroup\Content\Filament\Clusters\KnowledgeBase;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
use Filament\Pages\Enums\SubNavigationPosition;

class KnowledgeBaseClusterTest extends TestCase
{
    /**
     * Test sprawdzający czy dziedziczy po Filament Cluster
     */
    public function test_extends_filament_cluster(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $this->assertTrue($reflection->isSubclassOf('Filament\Clusters\Cluster'));
    }

    /**
     * Test sprawdzający czy ma ustawiony navigationSort
     */
    public function test_has_navigation_sort_property(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $navigationSortProperty = $reflection->getProperty('navigationSort');
        $navigationSortProperty->setAccessible(true);
        $navigationSort = $navigationSortProperty->getValue();

        $this->assertEquals(3, $navigationSort);
    }

    /**
     * Test sprawdzający czy ma ustawiony slug
     */
    public function test_has_slug_property(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $slugProperty = $reflection->getProperty('slug');
        $slugProperty->setAccessible(true);
        $slug = $slugProperty->getValue();

        $this->assertEquals('content/knowledge-base', $slug);
    }

    /**
     * Test sprawdzający czy ma ustawioną pozycję sub-nawigacji
     */
    public function test_has_sub_navigation_position(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $subNavigationProperty = $reflection->getProperty('subNavigationPosition');
        $subNavigationProperty->setAccessible(true);
        $subNavigation = $subNavigationProperty->getValue();

        $this->assertEquals(SubNavigationPosition::Top, $subNavigation);
    }

    /**
     * Test sprawdzający czy ma metodę getNavigationGroup
     */
    public function test_has_get_navigation_group_method(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $this->assertTrue($reflection->hasMethod('getNavigationGroup'));

        $method = $reflection->getMethod('getNavigationGroup');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy ma metodę getNavigationLabel
     */
    public function test_has_get_navigation_label_method(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $this->assertTrue($reflection->hasMethod('getNavigationLabel'));

        $method = $reflection->getMethod('getNavigationLabel');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający czy ma metodę getModelLabel
     */
    public function test_has_get_model_label_method(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $this->assertTrue($reflection->hasMethod('getModelLabel'));

        $method = $reflection->getMethod('getModelLabel');
        $this->assertTrue($method->isStatic());
        $this->assertTrue($method->isPublic());
    }

    /**
     * Test sprawdzający poprawny namespace
     */
    public function test_correct_namespace(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $this->assertEquals('MbeGroup\Content\Filament\Clusters', $reflection->getNamespaceName());
    }

    /**
     * Test sprawdzający czy klasa nie jest abstrakcyjna
     */
    public function test_is_not_abstract(): void
    {
        $reflection = new ReflectionClass(KnowledgeBase::class);

        $this->assertFalse($reflection->isAbstract());
    }
}
