<?php

namespace MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources;

use MbeGroup\Content\Filament\Resources\BaseContentResource;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase;
use MbeGroup\Content\Filament\Clusters\KnowledgeBase\Resources\DictionaryEntryResource\Pages;

class DictionaryEntryResource extends BaseContentResource
{
    protected static string $contentType = 'dictionary_entry';

    protected static ?string $slug = 'dictionary-entries';

    protected static ?string $cluster = KnowledgeBase::class;

    public static function getNavigationGroup(): ?string
    {
        return null;
    }

    public static function getNavigationSort(): ?int
    {
        return 1;
    }

    public static function getNavigationLabel(): string
    {
        return __('content::filament.resources.dictionary_terms.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('content::filament.resources.dictionary_terms.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('content::filament.resources.dictionary_terms.plural_model_label');
    }

    public static function getPages(): array
    {
        return [
            'index'  => Pages\ListDictionaryEntries::route('/'),
            'create' => Pages\CreateDictionaryEntry::route('/create'),
            'edit'   => Pages\EditDictionaryEntry::route('/{record}/edit'),
        ];
    }
}
