<?php

namespace MbeGroup\Content\Filament\Resources\ArticleResource\Pages;

use MbeGroup\Content\Filament\Resources\ArticleResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateArticle extends CreateRecord
{
    protected static string $resource = ArticleResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.resources.users.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
