<?php

namespace MbeGroup\Employer\Filament\Resources;

use MbeGroup\Employer\Models\Employer;

use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables;
use Filament\Tables\Table;
use MbeGroup\Employer\Filament\Resources\EmployerResource\Pages\ListEmployers;
use MbeGroup\Employer\Filament\Resources\EmployerResource\Pages\CreateEmployer;
use MbeGroup\Employer\Filament\Resources\EmployerResource\Pages\EditEmployer;
use Filament\Actions;
use Filament\Forms;
use App\ValueObject\Status;

class EmployerResource extends Resource
{
    protected static ?string $model = Employer::class;

    public static function getNavigationGroup(): string
    {
        return __('employer::filament.navigation.group.label');
    }

    public static function getNavigationLabel(): string
    {
        return __('employer::filament.resources.employer.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('employer::filament.resources.employer.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('employer::filament.resources.employer.plural_model_label');
    }

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label(__('employer::filament.resources.employer.form.fields.name'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('slug')
                    ->label(__('employer::filament.resources.employer.form.fields.slug'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('industry')
                    ->label(__('employer::filament.resources.employer.form.fields.industry'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('company_size')
                    ->label(__('employer::filament.resources.employer.form.fields.company_size'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('company_type')
                    ->label(__('employer::filament.resources.employer.form.fields.company_type'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('logo')
                    ->label(__('employer::filament.resources.employer.form.fields.logo'))
                    ->maxLength(255),
                Forms\Components\TextInput::make('cover_image')
                    ->label(__('employer::filament.resources.employer.form.fields.cover_image'))
                    ->maxLength(255),
                Forms\Components\TextInput::make('account_manager')
                    ->label(__('employer::filament.resources.employer.form.fields.account_manager'))
                    ->maxLength(255),
                Forms\Components\Select::make('status')
                        ->label(__('employer::filament.resources.employer.form.fields.status'))
                        ->options(Status::getLabels())
                        ->required()
                        ->default(Status::INACTIVE)
                        ->afterStateHydrated(function (Forms\Components\Select $component, $state): void {
                            if ($state instanceof Status) {
                                $component->state($state->value);
                            }
                        })
                        ->dehydrateStateUsing(function ($state): int {
                            return $state instanceof Status ? $state->value: (int) $state;
                        })
                        ->rule('integer')
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('ID')
                    ->sortable(),
                Tables\Columns\TextColumn::make('name')
                    ->label(__('employer::filament.resources.employer.table.columns.name'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('slug')
                    ->label(__('employer::filament.resources.employer.table.columns.slug'))
                    ->searchable(),
                Tables\Columns\IconColumn::make('status')
                    ->label(__('employer::filament.resources.employer.table.columns.status'))
                    ->state(fn ($record) => Status::int($record->status))
                    ->icon(fn ($state) => Status::icon($state))
                    ->color(fn ($state) => Status::color($state))
                    ->tooltip(fn ($state) => Status::label($state))
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                ->label(__('employer::filament.resources.employer.table.columns.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                ->label(__('employer::filament.resources.employer.table.columns.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                Actions\EditAction::make(),
                Actions\DeleteAction::make(),
            ])
            ->toolbarActions([
                Actions\BulkActionGroup::make([
                    Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->description('Version: ' . \Composer\InstalledVersions::getVersion('mbegroup/employer'));
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListEmployers::route('/'),
            'create' => CreateEmployer::route('/create'),
            'edit' => EditEmployer::route('/{record}/edit'),
        ];
    }
}
