<?php

namespace MbeGroup\Employer\Filament\Resources\EmployerResource\Pages;

use MbeGroup\Employer\Filament\Resources\EmployerResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateEmployer extends CreateRecord
{
    protected static string $resource = EmployerResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.resources.users.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
