<?php
namespace MbeGroup\Employer\Models;

use MongoDB\Laravel\Eloquent\Model;
use App\ValueObject\Status;

class Employer extends Model
{
    protected $connection = 'mongodb';
    protected $collection = 'employers';
    protected $fillable   = [
        'name',
        'slug',
        'industry',
        'company_size',
        'company_type',
        'logo',
        'cover_image',
        'account_manager',
        'status',
    ];

    protected $casts = [
        'status' => Status::class,
    ];
}
