<?php

namespace MbeGroup\Employer\Filament\Resources\EmployerResource\Pages;

use MbeGroup\Employer\Filament\Resources\EmployerResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;
use MbeGroup\Product\Models\ProductStatistics;
use MbeGroup\Product\Models\Product;
use App\ValueObject\Status;

class CreateEmployer extends CreateRecord
{
    protected static string $resource = EmployerResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.resources.users.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }

    protected function afterCreate(): void
    {
        $this->syncProductStatistics();
    }

    private function syncProductStatistics(): void
    {
        $record   = $this->getRecord();
        $products = $this->data['products'] ?? [];

        foreach ($products as $productData) {
            if (isset($productData['product_id'])) {
                $product = Product::find($productData['product_id']);
                if ($product) {
                    ProductStatistics::create([
                        'employer_id' => $record->getKey(),
                        'product_id'  => $productData['product_id'],
                        'quantity'    => $productData['quantity'] ?? 1,
                        'price'       => $product->price_net * ($productData['quantity'] ?? 1),
                        'valid_from'  => now(),
                        'valid_to'    => now()->addMonth(),
                        'status'      => $productData['status'] ?? Status::ACTIVE,
                    ]);
                }
            }
        }
    }
}
