<?php
namespace MbeGroup\Employer\Models;

use MongoDB\Laravel\Eloquent\Model;
use App\ValueObject\Status;
use App\Models\Dictionary;

class Employer extends Model
{
    protected $connection = 'mongodb';
    protected $collection = 'employers';
    protected $fillable   = [
        'name',
        'slug',
        'industry_id',
        'company_size_id',
        'company_type_id',
        'logo',
        'cover_image',
        'account_manager_id',
        'status',
        'product_ids',
        'products',
    ];

    protected $casts = [
        'status' => Status::class,
    ];

    public function industry()
    {
        return $this->belongsTo(Dictionary::class, 'industry_id');
    }

    public function companySize()
    {
        return $this->belongsTo(Dictionary::class, 'company_size_id');
    }

    public function companyType()
    {
        return $this->belongsTo(Dictionary::class, 'company_type_id');
    }

      /**
     * Relacja z zamówieniami produktów (tabela łącząca)
     */
    public function productOrders()
    {
        return $this->hasMany(\MbeGroup\Product\Models\ProductStatistics::class);
    }

      /**
     * Relacja many-to-many z produktami przez tabelę łączącą
     */
    public function products()
    {
        return $this->hasManyThrough(
            \MbeGroup\Product\Models\Product::class,
            \MbeGroup\Product\Models\ProductStatistics::class,
            'employer_id',
            'id',
            'id',
            'product_id'
        );
    }
}
