<?php

namespace Tests\Unit;

use MbeGroup\Employer\Providers\EmployerServiceProvider;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

class EmployerServiceProviderTest extends TestCase
{
    /**
     * Test tworzenia nowej instancji EmployerServiceProvider
     */
    public function test_can_create_service_provider_instance(): void
    {
        $app = $this->createMock(\Illuminate\Contracts\Foundation\Application::class);
        $provider = new EmployerServiceProvider($app);
        
        $this->assertInstanceOf(EmployerServiceProvider::class, $provider);
    }

    /**
     * Test sprawdzający czy klasa dziedziczy po ServiceProvider
     */
    public function test_extends_service_provider(): void
    {
        $app = $this->createMock(\Illuminate\Contracts\Foundation\Application::class);
        $provider = new EmployerServiceProvider($app);
        
        $this->assertInstanceOf(\Illuminate\Support\ServiceProvider::class, $provider);
    }

    /**
     * Test sprawdzający namespace klasy
     */
    public function test_class_namespace(): void
    {
        $reflection = new ReflectionClass(EmployerServiceProvider::class);
        
        $this->assertEquals('MbeGroup\Employer\Providers', $reflection->getNamespaceName());
        $this->assertEquals('EmployerServiceProvider', $reflection->getShortName());
    }

    /**
     * Test sprawdzający czy metoda boot istnieje
     */
    public function test_boot_method_exists(): void
    {
        $reflection = new ReflectionClass(EmployerServiceProvider::class);
        
        $this->assertTrue($reflection->hasMethod('boot'));
        
        $bootMethod = $reflection->getMethod('boot');
        $this->assertTrue($bootMethod->isPublic());
        $this->assertEquals('void', $bootMethod->getReturnType()?->getName());
    }

    /**
     * Test sprawdzający czy klasa jest finalna
     */
    public function test_class_is_final(): void
    {
        $reflection = new ReflectionClass(EmployerServiceProvider::class);
        
        $this->assertTrue($reflection->isFinal());
    }

    /**
     * Test sprawdzający czy wszystkie wymagane metody są zdefiniowane
     */
    public function test_required_methods_are_defined(): void
    {
        $reflection = new ReflectionClass(EmployerServiceProvider::class);
        
        $requiredMethods = ['boot'];
        
        foreach ($requiredMethods as $method) {
            $this->assertTrue(
                $reflection->hasMethod($method),
                "Metoda {$method} nie została znaleziona w klasie EmployerServiceProvider"
            );
        }
    }
}