<?php

namespace MbeGroup\Employer\Filament\Resources\EmployerResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use MbeGroup\Employer\Filament\Resources\EmployerResource;
use MbeGroup\Product\Models\ProductStatistics;
use MbeGroup\Product\Models\Product;
use App\ValueObject\Status;

class EditEmployer extends EditRecord
{
    protected static string $resource = EmployerResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function getFormActions(): array
    {
        return [
            $this->getSaveFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('employer::filament.resources.employer.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->save();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            $this->getCancelFormAction(),
        ];
    }

    protected function afterSave(): void
    {
        $this->syncProductStatistics();
    }

    private function syncProductStatistics(): void
    {

        $record             = $this->getRecord();
        $currentProducts    = collect($this->data['products'] ?? []);
        $currentItemIds     = $currentProducts->pluck('item_id')->filter()->toArray();
        $existingStatistics = ProductStatistics::where('employer_id', $record->getKey())
            ->get();

        $existingStatisticsList = $existingStatistics->filter(function ($statistic) use ($currentItemIds) {
            return !in_array($statistic->employer_item_id, $currentItemIds) && $statistic->status !== Status::INACTIVE;
        });

        foreach ($existingStatisticsList as $statistic) {
            $statistic->update([
            'status'     => Status::INACTIVE,
            'updated_at' => now(),
            ]);
        }

        foreach ($currentProducts as $productData) {
            if (isset($productData['product_id'])) {
                $product = Product::find($productData['product_id']);
                if ($product) {
                    $existingStatistic = $existingStatistics->firstWhere('employer_item_id', $productData['item_id']);
                      if ($existingStatistic) {
                          $existingStatistic->update([
                              'quantity'   => $productData['quantity'] ?? 1,
                              'price'      => $product->price_net * ($productData['quantity'] ?? 1),
                              'status'     => $productData['status'] ?? Status::ACTIVE,
                              'updated_at' => now()
                          ]);
                      } else {
                        ProductStatistics::create([
                            'employer_id'      => $record->getKey(),
                            'product_id'       => $productData['product_id'],
                            'employer_item_id' => $productData['item_id'],
                            'quantity'         => $productData['quantity'] ?? 1,
                            'price'            => $product->price_net * ($productData['quantity'] ?? 1),
                            'valid_from'       => now(),
                            'valid_to'         => now()->addMonth(),
                            'status'           => $productData['status'] ?? Status::ACTIVE,
                        ]);
                      }
                }
            }
        }
    }
}
