<?php

namespace MbeGroup\Employer\Filament;

use Filament\Contracts\Plugin;
use Filament\Panel;
use MbeGroup\Employer\Filament\Resources\EmployerResource;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;

class EmployerPlugin implements Plugin
{
    public function getId(): string { return 'employer'; }

    public function register(Panel $panel): void
    {
        $panel->resources([
            EmployerResource::class,
        ]);
    }

    public function boot(Panel $panel): void
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                NavigationGroup::make()
                     ->label(__('employer::filament.navigation.group.label'))
                     ->icon('heroicon-s-briefcase'),
            ]);
        });
    }
}
