<?php

namespace MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Forms;

use MbeGroup\HomeLayout\Filament\Resources\HomepageResource\Forms\FormsInterface;
use Filament\Forms\Form;
use Filament\Forms;
use Filament\Schemas\Schema;

class Article implements FormsInterface
{
    public static function formSchema(Schema $schema): Schema
    {
        return $schema->schema([
            Forms\Components\TextInput::make('name')
                ->label(__('home-layout::filament.resources.home_layout.form.fields.name'))
                ->required(),
            Forms\Components\TextInput::make('slug')
                ->label(__('home-layout::filament.resources.home_layout.form.fields.slug'))
                ->required(),
            Forms\Components\Toggle::make('enabled')
                ->label(__('home-layout::filament.resources.home_layout.form.fields.enabled'))
                ->default(true),
            Forms\Components\Group::make([
                Forms\Components\TextInput::make('color')
                    ->label(__('home-layout::filament.resources.home_layout.form.fields.color'))
                    ->required(),
                Forms\Components\TextInput::make('backgroud_color')
                    ->label(__('home-layout::filament.resources.home_layout.form.fields.backgroud_color'))
                    ->required(),
            ])->statePath('data'),
        ]);
    }
}
