<?php

namespace MbeGroup\HomeLayout\Contracts;

use MbeGroup\HomeLayout\Models\HomeLayout;

interface HomeLayoutServiceInterface
{
      /**
     * Get Home Layout by slug
     *
     * @param string $slug
     * @return HomeLayout
     */
    public function get(string $slug): HomeLayout;

      /**
     * Get Resource class by slug
     *
     * @param string $slug
     * @return string
     */
    public function getResourceBySlug(string $slug): string;
}
